<?php


namespace WPG\Gateway\Model\Traits;

/**
 * Trait for defining common variables and methods for all Payment Solutions
 * Trait OnlinePaymentMethod
 * @package WPG\Gateway\Model\Traits
 */
trait Logger
{

  /**
   * Collected debug information
   *
   * @var array
   */
  protected $_debugData = [];

  /**
  * Init Logger
  *
  * @return \Zend\Log\Logger
  */
  protected function _initLogger()
  {
    $writer = new \Zend\Log\Writer\Stream(BP . '/var/log/wpg.log');
    $logger = new \Zend\Log\Logger();
    $logger->addWriter($writer);
    return $logger;
  }

  /**
   * Log debug data to file
   *
   * @return void
   */
  protected function _writeDebugData()
  {
    if ($this->getConfigHelper()->getDebug()) {
      $this->getLogger()->debug(var_export($this->_debugData, true));
    }
  }

  /**
   * @param string $key
   * @param array|string $value
   * @return $this
   */
  protected function _addDebugData($key, $value)
  {
      $this->_debugData[$key] = $value;
      return $this;
  }
}
